\name{plot.ABF}
\alias{plot.ABF}
\title{Plots an ABF Object}
\description{
S3 method to plot \code{\link[=readABF]{ABF}} objects. Converts the ABF object to a data frame and then plots the data frame.
}
\usage{
\S3method{plot}{ABF}(x, pch = ".", \dots, sweep = 1, type = c("all", "one"),
channels, unit = NULL)
}
\arguments{
  \item{x}{an object of class ABF, typically generated by \code{\link{readABF}}.}
  \item{pch}{same as \code{pch} from \code{\link{par}}.}
  \item{...}{further arguments that will be passed to \code{\link{plot}}.}
  \item{sweep, type, channels, unit}{arguments that will be passed to \code{\link{as.data.frame.ABF}}.}
}

\seealso{
  \code{\link{as.data.frame.ABF}}
}

\examples{
# loads an example file and plots its first sweep
r <- readABF(system.file("extdata", "2009_01_19_0002_varlen_v18.abf", package="readABF"))
plot(r, sweep=1)

# leads to the same result
plot(as.data.frame(r, sweep=1), pch = ".")
}
