% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.R
\name{read_rds}
\alias{read_rds}
\alias{write_rds}
\title{Read/write RDS files.}
\usage{
read_rds(file, refhook = NULL)

write_rds(
  x,
  file,
  compress = c("none", "gz", "bz2", "xz"),
  version = 2,
  refhook = NULL,
  path = deprecated(),
  ...
)
}
\arguments{
\item{file}{The file path to read from/write to.}

\item{refhook}{A function to handle reference objects.}

\item{x}{R object to write to serialise.}

\item{compress}{Compression method to use: "none", "gz" ,"bz", or "xz".}

\item{version}{Serialization format version to be used. The default value is 2
as it's compatible for R versions prior to 3.5.0. See \code{\link[base:readRDS]{base::saveRDS()}}
for more details.}

\item{path}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}

\item{...}{Additional arguments to connection function. For example, control
the space-time trade-off of different compression methods with
\code{compression}. See \code{\link[=connections]{connections()}} for more details.}
}
\value{
\code{write_rds()} returns \code{x}, invisibly.
}
\description{
Consistent wrapper around \code{\link[=saveRDS]{saveRDS()}} and \code{\link[=readRDS]{readRDS()}}.
\code{write_rds()} does not compress by default as space is generally cheaper
than time.
}
\examples{
temp <- tempfile()
write_rds(mtcars, temp)
read_rds(temp)
\dontrun{
write_rds(mtcars, "compressed_mtc.rds", "xz", compression = 9L)
}
}
