% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{lgcp}
\alias{lgcp}
\title{Spatio-temporal Log-Gaussian Cox Process Model}
\usage{
lgcp(
  data,
  data.t = NULL,
  sp.covs = NULL,
  t.covs = NULL,
  pop.var = NULL,
  boundary,
  covariates = NULL,
  cellwidth,
  laglength,
  dirname = NULL,
  prevRun = NULL,
  mala.pars = c(26250, 20000, 50),
  nchains = parallel::detectCores(),
  lib = NULL
)
}
\arguments{
\item{data}{A data frame consisting of columns \code{x}, \code{y}, and \code{t}, which are two
spatial coordinates and time point respectively.}

\item{data.t}{A data frame containing any temporal covariates with a column \code{t} with the
time period and subsequent columns describing the value(s) of the covariates.}

\item{sp.covs}{A vector with the names of spatially-varying covariate to use in the model
(can be \code{NULL}). These must match the column names in \code{covariates}.}

\item{t.covs}{A vector with the names of temporally-varying covariates (can be \code{NULL}).
These names must match the names of columns in \code{data.t}.}

\item{pop.var}{The name of the population density variable to be used for the population
offset (can be \code{NULL}). This must match the name of a column in \code{covariates}.}

\item{boundary}{A \code{spatialPolygonsDataFrame} of the boundary of the area of interest.}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest and containing
the covariate and population density data.}

\item{cellwidth}{The width of cells of the computational grid.}

\item{laglength}{The number of time periods to include. The maximum value of \code{t} in \code{data}
is used as the present period, and time periods are counted back from this value.}

\item{dirname}{The directory root name to save model output. A directory is created for each
MCMC chain as \code{dirname.1}, \code{dirname.2}, etc. If NULL then a temporary directory is used,
this will result in the data being lost after the session in closed though.}

\item{prevRun}{Used to set prior distributions. Either output from a previous call to \code{lgcp}
to use posterior distributions from previous period, or a call to \code{lgcp::lgcpPrior}.}

\item{mala.pars}{Parameters for the MCMC sampler. A vector of three numbers: the total number
of iterations, the number of warmup iterations, and the number to thin.}

\item{nchains}{The number of MCMC chains, default is \code{parallel::detectCores()}}

\item{lib}{Library location if not the default, otherwise NULL}
}
\value{
An object of class lgcpReal
}
\description{
Bayesian inference for a spatio-temporal LGCP model with or without covariates.
}
\details{
The \code{lgcp} function provides a wrapper to several functions from the \code{lgcp} package.
It simplifies the workflow described in the vignette for that package, providing a single
function to generate the appropriate grid, covariate matrices and lists, and perform inference
with the function \code{lgcp::lgcpPredictSpatioTemporalPlusPars}. See the vignette for this
package for a description of the model. The implementation here allows for spatially and/or
temporally varying covariates but not spatio-temporally varying covariates, as in the time-scales
relevant to real-time surveillance applications these are not generally available. For users
requiring additional functionality, please refer to the \code{lgcp} package documentation.
}
\examples{
\donttest{
data(dat,square,square_pop)
lg1 <- lgcp(data=dat,
            pop.var = c("popdens"),
            boundary=square,
            covariates=square_pop,
            cellwidth=0.1,
            laglength = 7,
            mala.pars=c(200,100,1),
            nchains=2)
}
}
