% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{vpc}
\alias{vpc}
\title{Variance partition coefficient}
\usage{
vpc(lg, covariates, rr = FALSE)
}
\arguments{
\item{lg}{Output from a call to \code{lgcp}}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest and containing
the covariate and population density data. Typically the same object as specified in the
\code{covariates} argument in the call to \code{lgcp}.}

\item{rr}{Whether to report the VPC for the log relative risk (TRUE) or for the log
incidence (FALSE)}
}
\value{
Prints the quantiles of the VPC. An object called \code{outl} is exported to the
global environment which contains the samples from the model. Used to reduce loading time
of samples. This object is large so remove if no further analysis required.
}
\description{
Reports the proportion of variance attributable to the latent Gaussian process.
}
\details{
The total variance in either the log incidence or log relatve risk
can be partitioned into observed and latent components. It is assumed that
the log incidence and log relative risk are normally distributed so that the VPC is
equal to the variance of the latent Gaussian field over the total variance.
The variance depends on the intensity of the Poisson process so \code{vpc}
reports quantiles of the distribution of the variance partition coeffient across
the predicted values.
}
