make.cases <- function( PopulationAtRisk, requireAllGroups = FALSE )
  {
    if( class(PopulationAtRisk) != "PopulationAtRisk" )
      stop("This function has to be called with a 'PopulationAtRisk' object generated by 'build.population()'.")

    ncases <- 0
    
    PaR <- PopulationAtRisk

    groups <- PaR[[4]][,1]
    ngroups <- length( groups )
    lambdas <- PaR[[4]][,6]
    while (ncases<=0){ # Make sure we get some cases. No cc-study w/o cases.
      groupcases <- rpois( ngroups, lambdas )

      ## In case empty groups are not allowed
      ## we do this over and over until we do get
      ## cases in all groups.
      if ( requireAllGroups == TRUE ){
        while ( length( which(groupcases==0) ) > 0 ){ # Checks if there are empty groups.
          groupcases <- rpois( ngroups, lambdas )
          warning("There were empty groups in the cases. The simulation was rejected and repeated.
 If this happens often, your results may be biased.")
        }
      }
      
      ncases <- sum( groupcases )
      if (ncases==0) warning("Zero cases where created. The simulation was rejected and repeated.
 If this happens often, your results may be biased.")
    }
    
    PaR[[4]] <- data.frame( PaR[[4]], cases = groupcases )

    ## Zugirff vereinfachen, ohne attach() zu verwenden
    PaR.table <- PaR[[4]]
    
    ## Finden aller Hauptfaktoren als character()
    ## auer der 0:
    main <- unique( unlist( strsplit( as.character(groups), ":" ) ) )[-1]

    ## Jetzt knne wir den data.frame() einrichten mit der Abhngigen immer 1 und vorerst
    ## allen Exogenen gleich 0:

    endog <- as.character( PaR[[1]][[2]] ) # Name der Endogenen
    cases <- data.frame( rep(1,ncases) ) # Variable mit 1en schaffen
    names(cases) <- endog # Variable korrekt benennen
    for ( i in 1:length(main) )
      { # Die brigen Variablen anlegen
        var.name <- main[i] # Name der neu anzulegenden Variable.
        df.names <- names(cases) # Bisherige Variablennamen
        cases <- data.frame( cases, assign("new",0) ) # Eine neue Variable 'new' = 0 zum df hinzufgen.
        names(cases) <- c(df.names,var.name) # 'new' in den passenden Namen umbenennen.
      }
    ## Jetzt existiert der data.frame() der Flle, allerdings noch ohne die
    ## korrekten Ausprgungen der Exogenen.
    ## Fr die ersten groupcases[1] Flle sind alle Ausprgungen 0, d.h.
    ## wir fangen erst mit dem darauffolgenden Fall an, Einsen in die
    ## Exogenen zu schreiben:
    startindex <- groupcases[1] + 1

    ## Fr jede der folgenden Grupppen mssen wir nun auf Basis der Gruppennamen
    ## die Exogenen fllen.
    for ( i in 2:length(groups) )
      {
        endindex <- startindex+groupcases[i] - 1
        exog <- unlist(strsplit( as.character(groups[i]), ":")) # Auslesen der in der aktuellen Gruppe Eins zu setzenden Hauptfaktoren
        cases[ startindex:endindex, exog ] <- 1
        startindex <- startindex+groupcases[i]
      }
    
    return( cases )

  }
