% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{step_dummy}
\alias{step_dummy}
\title{Dummy Variables Creation}
\usage{
step_dummy(recipe, ..., role = "predictor", trained = FALSE,
  contrast = options("contrasts"), naming = function(var, lvl) paste(var,
  make.names(lvl), sep = "_"), levels = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will
be used to create the dummy variables. See \code{\link{selections}} for
more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned?. By default, the function assumes that the binary
dummy variable columns created by the original variables will be used as
predictors in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{contrast}{A specification for which type of contrast should be used
to make a set of full rank dummy variables. See
\code{\link[stats]{contrasts}} for more details. \bold{not currently
working}}

\item{naming}{A function that defines the naming convention for new binary
columns. See Details below.}

\item{levels}{A list that contains the information needed to create dummy
variables for each variable contained in \code{terms}. This is
\code{NULL} until the step is trained by \code{\link{prep.recipe}}.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_dummy} creates a a \emph{specification} of a recipe step that
  will convert nominal data (e.g. character or factors) into one or more
  numeric binary model terms for the levels of the original data.
}
\details{
\code{step_dummy} will create a set of binary dummy variables 
  from a factor variable. For example, if a factor column in the data set
  has levels of "red", "green", "blue", the dummy variable bake will
  create two additional columns of 0/1 data for two of those three values
  (and remove the original column).

By default, the missing dummy variable will correspond to the first level
  of the factor being converted.

The function allows for non-standard naming of the resulting variables. For
  a factor named \code{x}, with levels \code{"a"} and \code{"b"}, the
  default naming convention would be to create a new variable called
  \code{x_b}. Note that if the factor levels are not valid variable names
  (e.g. "some text with spaces"), it will be changed by
  \code{\link[base]{make.names}} to be valid (see the example below). The
  naming format can be changed using the \code{naming} argument.
}
\examples{
data(okc)
okc <- okc[complete.cases(okc),]

rec <- recipe(~ diet + age + height, data = okc)

dummies <- rec \%>\% step_dummy(diet)
dummies <- prep(dummies, training = okc)

dummy_data <- bake(dummies, newdata = okc)

unique(okc$diet)
grep("^diet", names(dummy_data), value = TRUE)
}
\concept{
preprocessing dummy_variables model_specification dummy_variables
  variable_encodings
}
\keyword{datagen}
