% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{summary.recipe}
\alias{summary.recipe}
\title{Summarize a recipe}
\usage{
\method{summary}{recipe}(object, original = FALSE, ...)
}
\arguments{
\item{object}{A \code{recipe} object}

\item{original}{A logical: show the current set of variables or the original
set when the recipe was defined.}

\item{...}{further arguments passed to or from other methods (not currently
used).}
}
\value{
A tibble with columns \code{variable}, \code{type}, \code{role},
and \code{source}. When \code{original = TRUE}, an additional column is included
named \code{required_to_bake} (based on the results of
\code{\link[=update_role_requirements]{update_role_requirements()}}).
}
\description{
This function prints the current set of variables/features and some of their
characteristics.
}
\details{
Note that, until the recipe has been trained,
the current and original variables are the same.

It is possible for variables to have multiple roles by adding them with
\code{\link[=add_role]{add_role()}}. If a variable has multiple roles, it will have more than one
row in the summary tibble.
}
\examples{
rec <- recipe(~., data = USArrests)
summary(rec)
rec <- step_pca(rec, all_numeric(), num_comp = 3)
summary(rec) # still the same since not yet trained
rec <- prep(rec, training = USArrests)
summary(rec)
}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep]{prep()}}
}
