% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{endRecord}
\alias{endRecord}
\alias{endRecord,Recordr-method}
\title{End the recording session that was started by \code{startRecord()}}
\usage{
endRecord(recordr)

\S4method{endRecord}{Recordr}(recordr)
}
\arguments{
\item{recordr}{A Recordr instance}
}
\value{
id The execution identifier that uniquely identifiers this execution.
}
\description{
The recordring session started by the \code{startRecord()} method is
terminated and all provenance collecting is discontinued. A log of all the
console commands is saved.
}
\examples{
\dontrun{
rc <- new("Recordr")
startRecord(rc, tag="my first console run")
x <- read.csv(file="./test.csv")
runIdentifier <- endRecord(rc)
}
}
\seealso{
\code{\link[=Recordr-class]{Recordr}} { class description}
}

