% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{kml}
\alias{kml}
\title{Output kml files.}
\usage{
kml(spData, zone = NULL, filename, mapoption = "aoo", smooth = 0, rad = 0.1)
}
\arguments{
\item{spData}{One of three options: 1) matrix of longitude and latitude (two columns) of each occurrence record; 2) matrix of easting and northing (two columns, e.g. UTM) of each occurrence record in meters;  3) RasterLayer object of predicted distribution (0/1 values).}

\item{zone}{UTM zone if data is in metric units.}

\item{filename}{The name of file to save, should end with .kml.}

\item{mapoption}{Type of representation, any of "points", "eoo" or "aoo".}

\item{smooth}{Smooths the kml lines as per IUCN guidelines. Higher values represent smoother polygons.}

\item{rad}{radius of circles in degrees if mapoption is "points". It can be the same value for all points or a vector with length equal to number of records in spData representing associated error. The default is about 10km (0.1 degrees) as per IUCN guidelines.}
}
\value{
A kml with polygon or circles around records.
}
\description{
Creates kml files for Google Maps as required by IUCN guidelines.
}
