% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map.draw}
\alias{map.draw}
\title{Map creation.}
\usage{
map.draw(
  longlat = NULL,
  layer,
  spName,
  borders = FALSE,
  scale = TRUE,
  legend = FALSE,
  sites = TRUE,
  mcp = FALSE,
  print = FALSE
)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude or eastness and northness (two columns in this order) of each occurrence record.}

\item{layer}{RasterLayer object representing the presence/absence map for the species.}

\item{spName}{String of species name.}

\item{borders}{If TRUE country borders are drawn.}

\item{scale}{If TRUE a distance scale in km is drawn.}

\item{legend}{If TRUE the legend for the map is drawn.}

\item{sites}{If TRUE the record locations are drawn.}

\item{mcp}{If TRUE the minimum convex polygon representing the Extent of Occurrence is drawn.}

\item{print}{If TRUE a pdf is saved instead of the output to the console.}
}
\description{
Creates maps ready to print in pdf or other formats.
}
\examples{
records = red.examples("red.records")
range = red.examples("red.range")
par(mfrow = c(1,2))
map.draw(records, layer = range, mcp = TRUE)
}
