% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\docType{methods}
\name{confint,rateReg-method}
\alias{confint,rateReg-method}
\title{Confidence Intervals for Covariate Coefficients}
\usage{
\S4method{confint}{rateReg}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{rateReg-class object.}

\item{parm}{A specification of which parameters are
to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{An optional numeric value to specify
the confidence level required.
By default, the value is 0.95,
which produces 95\% confidence intervals.}

\item{...}{Other arguments for future usage.}
}
\value{
A numeric matrix with rownames and colnames.
}
\description{
\code{confint,rateReg-method} is a S4 class method for
\code{\link{rateReg}} object, which returns approximate
confidence intervals for all or specified covariates.
}
\details{
Under regularity condition (Shao, 2003,
Theorem 4.16 and Theorem 4.17, page 287, 290),
the approximate confidence intervals are constructed loosely
based on Fisher information matrix and estimates of coefficients.
}
\examples{
## See examples given in function rateReg.
}
\references{
Shao, J. (2003), \emph{Mathematical statistics},
Springer texts in statistics, New York: Springer, 2nd Edition.
}
\seealso{
\code{\link{rateReg}} for model fitting;
\code{\link{coef,rateReg-method}} for point estimates
of covariate coefficients;
\code{\link{summary,rateReg-method}} for summary of a fitted model.
}

