% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Survr.R
\name{Survr}
\alias{Survr}
\title{Formula Response for Recurrent Event Data}
\usage{
Survr(ID, time, event, origin = 0, check = TRUE, ...)
}
\arguments{
\item{ID}{Subject identificators. It can be numeric vector, character
vector, or a factor vector.}

\item{time}{Time of reccurence event or censoring. In addition to numeric
values, \code{Date} and \code{difftime} are supported and converted to
numeric values.}

\item{event}{A numeric vector indicating failure cost or event indicator
taking positive values as costs (\code{1} as events), and non-positive
values as censoring.  Logical vector is allowed and will be converted to
numeric vector.}

\item{origin}{The time origin of each subject or process. In addition to
numeric values, \code{Date} and \code{difftime} are also supported and
converted to numeric values.  Different subjects may have different
origins. However, one subject must have the same origin.}

\item{check}{A logical value suggesting whether to perform data checking
procedure. The default value is \code{TRUE}. \code{FALSE} should be set
with caution and only for processed data already in recerruent event
data framework.}

\item{...}{Other arguments for future usage.}
}
\description{
\code{Survr} is an S4 class that represents
formula response for recurrent event data
modeled by methods based on counts and rate function.
}
\details{
This is a similar function to \code{Survr} in package
\pkg{survrec} but with a more considerate checking procedure embedded for
recurrent event data modeled by methods based on counts and rate function.
The checking rules apply to each subject respectively and include that
\itemize{
    \item Subject identification, event times, censoring time, and event
        indicator cannot be missing or contain missing values.
    \item There has to be only one censoring time not earlier than
        any event time.
    \item The time origin has to be the same and not later than any event
        time.
}
}
\seealso{
\code{\link{rateReg}} for model fitting.
}
