#' @name exportVersion
#' @aliases exportVersion.redcapApiConnection
#' @aliases exportVersion.redcapDbConnection
#' @export exportVersion
#' @importFrom httr POST
#'
#' @title Exports the REDCap Version Number
#' @description Version numbers are returned as a character string.
#'   This feature is available for REDCap 6.0.0 and higher.
#'
#' @param rcon A REDCap connection object as generated by \code{redcapConnection}
#' @param ... Arguments to be passed to other methods.
#'
#' @details If this function is used in a version of REDCap that does not
#'   support the Export Version Number function, the character string
#'   \code{'Version Unknown'} is returned.
#'
#' @author Benjamin Nutter
#'
#' @references
#' Please refer to your institution's API documentation.
#'
#' Additional details on API parameters are found on the package wiki at
#' \url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
#'


exportVersion <- function(rcon, ...) UseMethod("exportVersion")

#' @rdname exportVersion
#' @export

exportVersion.redcapDbConnection <- function(rcon, ...){
  message("Please accept my apologies.  The exportVersion method for redcapDbConnection objects\n",
          "has not yet been written.  Please consider using the API.")
}

#' @rdname exportVersion
#' @export

exportVersion.redcapApiConnection <- function(rcon, ...){
  .params <- list(token=rcon$token, content='version', returnFormat='csv')
  x <- httr::POST(url=rcon$url, body=.params, config=rcon$config)

  if (x$status_code == "200")
    return(as.character(x$content))
  #*** When this API function isn't available (ie, before version 6.0),
  #*** we want to avoid throwing a disruptive error. Instead, we
  #*** return the message that indicates the version is unknown.
  else if (as.character(x) ==  "The value of the parameter \"content\" is not valid") return("Version Unknown")
  else return(as.character(x))
}
