% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportBundle.R
\name{exportBundle}
\alias{exportBundle}
\alias{exportBundle.redcapApiConnection}
\title{Perform a bundle of API calls.}
\usage{
exportBundle(
  rcon,
  date = TRUE,
  label = TRUE,
  meta_data = TRUE,
  users = TRUE,
  instruments = TRUE,
  events = TRUE,
  arms = TRUE,
  mappings = TRUE,
  version = TRUE,
  ...
)

\method{exportBundle}{redcapApiConnection}(
  rcon,
  date = TRUE,
  label = TRUE,
  meta_data = TRUE,
  users = TRUE,
  instruments = TRUE,
  events = TRUE,
  arms = TRUE,
  mappings = TRUE,
  version = TRUE,
  ...,
  return_object = TRUE
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{date}{Logical. If \code{TRUE}, user expiration dates are converted to
\code{POSIXct} objects.}

\item{label}{Logical.  If \code{TRUE}, the user form permissions are
converted to labeled factors.}

\item{meta_data}{Logical.  Indicates if the meta data (data dictionary)
should be exported.}

\item{users}{Logical. Indicates if the users table should be exported.}

\item{instruments}{Logical. Indicates if the instruments table should be exported.}

\item{events}{Logical. Indicates if the event names should be exported.}

\item{arms}{Logical. Indicates if the arms table should be exported.}

\item{mappings}{Logical. Indicates if the form-event mappings should
be exported.}

\item{version}{Indicates if the REDCap version number should be exported.
Only applicable in REDCap 6.0.0 and higher.}

\item{...}{Arguments to be passed to other methods}

\item{return_object}{Logical.  When \code{TRUE}, the \code{exportBundle} object
is returned to the workspace.}
}
\description{
This function is deprecated and will be removed with the release of
\code{redcapAPI} 3.0.0. It's functionality is built into caching of
data onto the \code{redcapConnection} object.

Several of the API calls return objects that can be used to perform
various validations in \code{exportRecords}, \code{exportReports}, and other
methods.  Using an export bundle allows the user to call these methods once and
store the result instead of issuing an additional call to the API each
time a method is invoked.

For example, if the user is uploading several files to the API, without an
export bundle, \code{importFiles} will utilize the \code{exportMetaData}
on each call in order to perform validations.  Using a bundle allows the user
to download the meta data once and refer to it on every subsequent call
that requires the data dictionary.
}
\details{
The project information is stored in the option
\code{redcap_project_info}.  If the project is not longitudinal, the
events, arms, and event-form mappings elements will be assigned character
vectors instead of data frames.
}
