% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteFiles.R
\name{deleteFiles}
\alias{deleteFiles}
\alias{deleteFiles.redcapApiConnection}
\title{Delete a File attached to a Record}
\usage{
deleteFiles(rcon, record, field, event, ...)

\method{deleteFiles}{redcapApiConnection}(
  rcon,
  record = NULL,
  field = NULL,
  event = NULL,
  repeat_instance = NULL,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{record}{The record ID in which the desired file is stored. Must be length 1.}

\item{field}{The field name in which the file is stored. Must be length 1.}

\item{event}{The event name for the file.  Must be length 1.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message.}

\item{...}{Arguments to be passed to other methods}

\item{repeat_instance}{The repeat instance number of the repeating
event or the repeating instrument. When available in your instance
of REDCap, and passed as NULL, the API will assume a value of 1.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This function allows you to remove a document that has been 
attached to an individual record
}
\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
