% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weighted_adj.R
\name{redist.plot.wted.adj}
\alias{redist.plot.wted.adj}
\title{Plot Weighted Border Adjacency}
\usage{
redist.plot.wted.adj(
  shp,
  plans,
  counties = NULL,
  ref = TRUE,
  adj = NULL,
  plot_shp = TRUE
)
}
\arguments{
\item{shp}{A SpatialPolygonsDataFrame, sf object, or redist_map. Required.}

\item{plans}{A `redist_plans` object or matrix of redistricting plans, where each
column indicates a plan and each}

\item{counties}{unquoted name of a column in `shp` or a vector of county assignments. Subsets to
edges which cross this boundary if supplied.}

\item{ref}{Plot reference map? Defaults to TRUE which gets the existing plan from}

\item{adj}{A zero-indexed adjacency list. Extracted from `shp` if `shp` is a `redist_map`.
Otherwise created with redist.adjacency if not supplied. Default is NULL.}

\item{plot_shp}{Should the shapes be plotted? Default is TRUE.}
}
\value{
ggplot
}
\description{
Plots the weighted adjacency graph by how often precincts coocur. If an argument
to counties is provided, it subsets the edges to plot to those that cross over the county boundary.
}
\examples{
data(iowa)
shp <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
plans <- redist_smc(shp, 100)
redist.plot.wted.adj(shp, plans = plans, counties = region)
}
