% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_district_fuzzy}
\alias{splits_district_fuzzy}
\title{Fuzzy Splits by District (Experimental)}
\usage{
splits_district_fuzzy(plans, shp, nbr, thresh = 0.01, epsg)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame with an \code{sf} geometry column.}

\item{nbr}{Geographic neighborhood, community, or other unit to check splits for.}

\item{thresh}{Percent as decimal of an area to trim away. Default is .01, which is 1\%.}

\item{epsg}{Numeric EPSG code to use to project the shapefile, if needed. Default is 3857.}
}
\value{
numeric matrix
}
\description{
Not all relevant geographies nest neatly into Census blocks, including communities
of interest or neighborhood. For these cases, this provides a tabulation by district of
the number of splits. As some geographies can be split multiple times, the
sum of these splits may not reflect the total number of splits.
}
\details{
Beware, this requires a \code{nbr} shape input and will be slower than checking splits in cases where
administrative unit nests cleanly into the geographies represented by \code{shp}.
}
\examples{
data(nh)
data(nh_m)

# toy example,
# suppose we care about the splits of the counties and they don't nest
nh_cty <- nh \%>\% dplyr::group_by(county) \%>\% dplyr::summarize()

# For a single plan:
splits_district_fuzzy(plans = nh$r_2020, shp = nh, nbr = nh_cty)

# Or many plans:
splits_district_fuzzy(plans = nh_m[, 3:5], shp = nh, nbr = nh_cty)
}
\concept{splits}
