% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.R
\name{tally}
\alias{tally}
\title{Tally a Column by District}
\usage{
tally(plans, shp, x)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{x}{The numeric vector to tally.}
}
\value{
A numeric vector with the tallies. Can be shaped into a
district-by-plan matrix.
}
\description{
Helper function to aggregate a vector by district. Can be used to calculate
total population, group percentages, and more.
}
\examples{
data(nh)
data(nh_m)

tally(nh_m, nh, pop) # total population
tally(nh_m, nh, vap_hisp) / tally(nh_m, nh, vap) # HVAP

}
