% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_clean.R
\name{refdb_clean_tax_remove_uncertainty}
\alias{refdb_clean_tax_remove_uncertainty}
\title{Remove terms indicating uncertainty in taxonomic names}
\usage{
refdb_clean_tax_remove_uncertainty(x, cols = NULL)
}
\arguments{
\item{x}{a reference database.}

\item{cols}{an optional vector of column names.
If \code{NULL} (default), the function is applied to the columns
associated with the \code{taxonomy} and \code{organism} fields.}
}
\value{
A reference database.
}
\description{
Remove terms indicating uncertainty in taxonomic names
}
\section{Warning}{

Marks of taxonomic uncertainty provided by specialists
are not without value. The consequences of their deletion
must be well understood by the user before using this function.
}

\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_clean_tax_remove_uncertainty(lib)

}
