% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_filter.R
\name{refdb_filter_ref_scope}
\alias{refdb_filter_ref_scope}
\title{Filter records by taxonomic scope of studies}
\usage{
refdb_filter_ref_scope(x, max_tax)
}
\arguments{
\item{x}{a reference database (tibble).}

\item{max_tax}{the maximum (widest) taxonomic focus of the study.}
}
\value{
a reference database (tibble).
}
\description{
Filter records by taxonomic scope of studies
}
\details{
A reference field (one ore more columns) must be set to use
this function. If reference is not available (NA) for a record,
the record is not dropped.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
lib$refs <- rep("REF_1", nrow(lib))
lib <- refdb_set_fields(lib, reference = "refs")
refdb_filter_ref_scope(lib, max_tax = "family_name")

}
