% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algoInvHist.R
\name{getSumForPArea}
\alias{getSumForPArea}
\title{Helper function to calculate the amount of observed and estimated data points within specified regions around the peak.}
\usage{
getSumForPArea(
  pLimitMin,
  pLimitMax,
  countsPred,
  indexPeak,
  HistData,
  countsFullHist,
  lambda,
  mu,
  sigma
)
}
\arguments{
\item{pLimitMin}{(numeric) vector specifying the lower limits for the regions next to the peak}

\item{pLimitMax}{(numeric) vector specifying the upper limits for the regions next to the peak}

\item{countsPred}{(numeric) vector with the predicted counts}

\item{indexPeak}{(integer) specifying the position of the peak}

\item{HistData}{(list) with histogram data generated by function \code{\link{generateHistData}}}

\item{countsFullHist}{(integer) vector with the observed counts}

\item{lambda}{(numeric) transformation parameter for inverse Box-Cox transformation}

\item{mu}{(numeric) parameter of the mean of non-pathological distribution}

\item{sigma}{(numeric) parameter of the standard deviation of non-pathological distribution}
}
\value{
(list) with two numeric vectors specifying the amount of observed and estimated data points surrounding the peak
}
\description{
The function helps to define the search region for P (fraction of non-pathological samples).
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
