% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_estimation.R
\name{em_estimation}
\alias{em_estimation}
\title{Penalized expectation-maximization algorithm.}
\usage{
em_estimation(
  p,
  item_data,
  pred_data,
  prox_data,
  mean_predictors,
  var_predictors,
  item_type,
  theta,
  pen_type,
  tau_vec,
  id_tau,
  num_tau,
  alpha,
  gamma,
  pen,
  anchor,
  final_control,
  samp_size,
  num_items,
  num_responses,
  num_predictors,
  num_quad,
  adapt_quad,
  optim_method,
  em_history,
  em_limit,
  NA_cases
)
}
\arguments{
\item{p}{List of parameters with starting values obtained from preprocess.}

\item{item_data}{Matrix or data frame of item responses.}

\item{pred_data}{Matrix or data frame of DIF and/or impact predictors.}

\item{prox_data}{Vector of observed proxy scores.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{item_type}{Optional character value or vector indicating the type of
item to be modeled.}

\item{theta}{Vector of fixed quadrature points.}

\item{pen_type}{Character value indicating the penalty function to use.}

\item{tau_vec}{Vector of tau values that either are automatically generated
or provided by the user. The first \code{tau_vec} will be equal to \code{Inf}
to identify a minimal value of tau in which all DIF is removed from the
model.}

\item{id_tau}{Logical indicating whether to identify the minimum value of tau
in which all DIF parameters are removed from the model.}

\item{num_tau}{Numeric value indicating the number of tau values to run
regDIF on.}

\item{alpha}{Numeric value indicating the alpha parameter in the elastic net
penalty function.}

\item{gamma}{Numeric value indicating the gamma parameter in the MCP
function.}

\item{pen}{Index for the tau vector.}

\item{anchor}{Optional numeric value or vector indicating which item
response(s) are anchors (e.g., \code{anchor = 1}).}

\item{final_control}{Control parameters.}

\item{samp_size}{Numeric value indicating the sample size.}

\item{num_items}{Numeric value indicating the number of items.}

\item{num_responses}{Vector with number of responses for each item.}

\item{num_predictors}{Numeric value indicating the number of predictors.}

\item{num_quad}{Numeric value indicating the number of quadrature points.}

\item{adapt_quad}{Logical value indicating whether to use adaptive quad.
needs to be identified.}

\item{optim_method}{Character value indicating the type of optimization
method to use.}

\item{em_history}{List to save EM iterations for supplemental EM algorithm.}

\item{em_limit}{Logical value indicating whether the EM algorithm reached
the maxit limit in the previous estimation round.}

\item{NA_cases}{Logical vector indicating if observation is missing.}
}
\value{
a \code{"list"} of matrices with unprocessed model estimates
}
\description{
Penalized expectation-maximization algorithm.
}
\keyword{internal}
