% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{beta.lme}
\alias{beta.lme}
\title{Standardized coeffients of a model.}
\usage{
\method{beta}{lme}(model, x = TRUE, y = TRUE, skip = NULL, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lme'.}

\item{x}{Logical. Whether or not to standardize predictor variables.}

\item{y}{Logical. Whether or not to standardize criterion variables.}

\item{skip}{A string vector indicating any variables you do \emph{not} wish
to be standarized.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
Returns the summary of a multi-level linear model, with the output
  showing the beta coefficients, standard error, t-values, and p-values for
  each predictor.
}
\description{
\code{beta.lme} returns the summary of a linear model where all variables
have been standardized.
}
\details{
This function takes a multi-level model and standardizes the variables,
in order to produce standardized (i.e., beta) coefficients rather than
unstandardized (i.e., B) coefficients.

Unlike similar functions, this function properly calculates standardized
estimates for interaction terms (by first standardizing each of the
individual predictor variables).
}
\examples{
# iris data
if (require(nlme, quietly=TRUE)) {
    model <- lme(Sepal.Width ~ Sepal.Length + Petal.Length, random=~1|Species, data=iris)
    beta(model)  # all three variables standardized

    beta(model, skip='Petal.Length')  # all variables except Petal.Length standardized
}
}
\seealso{
\code{\link{beta.lm}}, \code{\link{beta.glm}}, \code{\link{beta.merMod}}
}

