% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpca_gauss.R
\name{fpca_gauss}
\alias{fpca_gauss}
\title{Functional principal components analysis via variational EM}
\usage{
fpca_gauss(
  Y,
  npc = 1,
  Kt = 8,
  maxiter = 20,
  t_min = NULL,
  t_max = NULL,
  print.iter = FALSE,
  row_obj = NULL,
  seed = 1988,
  ...
)
}
\arguments{
\item{Y}{Dataframe. Should have variables id, value, index.}

\item{npc}{Defaults to 1. Number of principal components to calculate.}

\item{Kt}{Number of B-spline basis functions used to estimate mean functions. Default is 8.}

\item{maxiter}{Maximum number of iterations to perform for EM algorithm. Default is 50.}

\item{t_min}{Minimum value to be evaluated on the time domain.}

\item{t_max}{Maximum value to be evaluated on the time domain.}

\item{print.iter}{Prints current error and iteration}

\item{row_obj}{If NULL, the function cleans the data and calculates row indices. 
Keep this NULL if you are using standalone \code{register} function.}

\item{seed}{Set seed for reproducibility. Default is 1991.}

\item{...}{Additional arguments passed to or from other functions}
}
\value{
An object of class \code{fpca} containing:
\item{knots}{Cutpoints for B-spline basis used to rebuild \code{alpha}.}
\item{efunctions}{\eqn{D \times npc} matrix of estimated FPC basis functions.}
\item{evalues}{Estimated variance of the FPC scores.}
\item{npc}{number of FPCs.}
\item{scores}{\eqn{I \times npc} matrix of estimated FPC scores.}
\item{alpha}{Estimated population-level mean.}
\item{mu}{Estimated population-level mean. Same value as \code{alpha} but included for compatibility
with \code{refund.shiny} package.}
\item{subject_coefs}{B-spline basis coefficients used to construct subject-specific means. 
For use in \code{registr()} function.}
\item{Yhat}{FPC approximation of subject-specific means.}
\item{Y}{The observed data.}
\item{family}{\code{gaussian}, for compatibility with \code{refund.shiny} package.}
\item{sigma2}{Estimated error variance}
}
\description{
Function used in the FPCA step for registering functional data,
called by \code{\link{register_fpca}} when \code{family = "gaussian"}. 
Parameters estimated based on probabilistic PCA framework originally 
introduced by Tipping and Bishop in 1999.
}
\references{
Tipping, M. E. and Bishop, C (1999). Probabilistic Principal Component Analysis.
\emph{Journal of the Royal Statistical Society Series B,}, 592--598.
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu},
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
