% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{custom_family}
\alias{custom_family}
\title{Family representing a GLM with custom distribution and link function}
\usage{
custom_family(distribution, inverse_link)
}
\arguments{
\item{distribution}{The distribution of the random component. This should be
in the form of a function taking one argument, the vector of values on the
inverse link scale, and returning a vector of draws from the distribution.}

\item{inverse_link}{The inverse link function.}
}
\value{
A family object representing this family
}
\description{
Allows specification of the random component and link function for a response
variable. In principle this could be used to specify any GLM family, but it
is usually easier to use the predefined families, such as \code{gaussian()} and
\code{binomial()}.
}
\details{
A GLM is specified by a combination of:
\itemize{
\item Random component, i.e. the distribution that Y is drawn from
\item Link function relating the mean of the random component to the linear predictor
\item Linear predictor
}

Using \code{custom_family()} we can specify the random component and link
function, while the linear predictor is set in \code{population()} when setting up
the population relationships. A family specified this way can be used to
specify a population (via \code{population()}), but can't be used to estimate a
model (such as with \code{glm()}).
}
\examples{
# A zero-inflated Poisson family
rzeroinfpois <- function(ys) {
  n <- length(ys)
  rpois(n, lambda = ys * rbinom(n, 1, prob = 0.4))
}

custom_family(rzeroinfpois, exp)
}
\seealso{
\code{\link[=ols_with_error]{ols_with_error()}} for the special case of linear regression with
custom error distribution
}
