% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haplen.R
\name{plot.haplen}
\alias{plot.haplen}
\title{Plot the length of extended haplotypes around a focal marker}
\usage{
\method{plot}{haplen}(x, allele = NA, group_by_allele = TRUE,
  main = paste0("Haplotype length around '", x$mrk.name, "'"),
  xlab = "Position", xlim = NULL, col = c("blue", "red", "violet",
  "orange"), mrk.col = "gray", lwd = 1, hap.names = NULL,
  pos.lab = "left", offset.lab = 0.5, cex.lab = 1, bty = "n",
  legend = NA, legend.xy.coords = "automatic", ...)
}
\arguments{
\item{x}{an object of class \code{haplen} generated by \code{\link{calc_haplen}}.}

\item{allele}{if \code{NA} (default), haplotypes of all alleles are plotted,
otherwise for the specified alleles. Alleles must be specified by their
internal coding, i.e. '0' for ancestral resp. major allele, etc.}

\item{group_by_allele}{logical. If \code{TRUE} (default), group chromosomes
by their allele at the focal marker. Otherwise haplotypes are drawn by
their order in the input file.}

\item{main}{main title of the plot. By default, the name of the focal marker.}

\item{xlab}{title of the x-axis.}

\item{xlim}{x coordinate ranges. If \code{NULL}, maximal range of haplotype length are taken.}

\item{col}{color for each allele (as coded internally).}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{lwd}{line width.}

\item{hap.names}{a vector containing the names of chromosomes.}

\item{pos.lab}{position of haplotype labels. Either \code{"left"} , \code{"right"} or \code{"both"}.}

\item{offset.lab}{offset of labels.}

\item{cex.lab}{relative letter size of labels.}

\item{bty}{type of box around plot (see \code{\link[graphics]{par}}).}

\item{legend}{legend text.}

\item{legend.xy.coords}{if \code{"automatic"} (default) places legend either top left or top right;
if \code{"none"}, no legend is drawn; otherwise argument is passed to \code{\link[graphics]{legend}}.}

\item{...}{other parameters to be passed to \code{\link[graphics]{plot.default}}.}
}
\description{
Plot the length of extended haplotype around a focal marker.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#plotting length of extended haplotypes for both ancestral and derived allele
#of the marker "F1205400"
#which displays a strong signal of selection
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
h <- calc_haplen(f)
plot(h)
plot(h, hap.names = hap.names(haplohh_cgu_bta12), cex.lab = 0.3)
}
\seealso{
\code{\link{calc_haplen}}, \code{\link{plot.furcation}}.
}
