% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribplot.R
\name{distribplot}
\alias{distribplot}
\title{Plot distribution of standardized iHS, Rsb or XP-EHH values}
\usage{
distribplot(
  data,
  lty = 1,
  lwd = 1.5,
  col = c("blue", "red"),
  qqplot = FALSE,
  resolution = 0.01,
  ...
)
}
\arguments{
\item{data}{a vector of iHS, Rsb or XPEHH values.}

\item{lty}{line type.}

\item{lwd}{line width.}

\item{col}{a vector describing the colors of the observed and Gaussian distribution, respectively.}

\item{qqplot}{logical. If \code{TRUE} a qq-plot is drawn instead of the distribution density curve.}

\item{resolution}{affects only qqplot. Rasterize data points to a quadratic grid with the specified resolution and remove
duplicate points. Defaults to 0.01.}

\item{...}{further arguments passed to \code{\link[graphics]{plot.default}}.}
}
\value{
The function returns a plot.
}
\description{
Plot the observed distribution of standardized iHS, Rsb or XP-EHH values together with
the standard Gaussian distribution.
}
\examples{
library(rehh.data)
#results from a genome scan (44,057 SNPs) see ?wgscan.cgu for details
data(wgscan.cgu)
#extract vector with iHS values from data frame
IHS <- ihh2ihs(wgscan.cgu)$ihs[["IHS"]]
distribplot(IHS, main = "iHS (CGU population)")
distribplot(IHS, main = "iHS (CGU population)", qqplot = TRUE)
}
\seealso{
\code{\link{ihh2ihs}}, \code{\link{ines2rsb}}, \code{\link{ies2xpehh}}, \code{\link{manhattanplot}}.
}
