% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinforced.R
\name{modelFit}
\alias{modelFit}
\title{Model fit for the training set}
\usage{
modelFit(Y, X, Z, startT, link, pve, nbasis, weight)
}
\arguments{
\item{Y}{The outcome variable, vector of length \eqn{n}, taking values in \eqn{{1, 0, NA}}, where 1 = disease, 0 = not, NA = missing.}

\item{X}{Observed longitudinal biomarker, matrix of \eqn{n} by \eqn{nTotal}, where \eqn{nTotal} denotes the total number of time grids.
Missing values are denoted by NA.}

\item{Z}{Other baseline covariates.}

\item{startT}{Time of the first prediction, denoted by \eqn{t_1} in the manuscript. For instance, if the time grids are \eqn{{0,1/60,2/60,...,1}},
then startT = 25 means that the first prediction is made at \eqn{t = 24/60}.}

\item{link}{The link function used in functional generalized linear models, e.g. "logit", "probit".}

\item{pve}{Proportion of variance explained in FPCA.}

\item{nbasis}{Number of B-spline basis functions needed for estimation of the mean function and smoothing of covariance.}

\item{weight}{Weight for each individual.}
}
\value{
\item{list_fpcaFit}{FPCA decomposition at each time grid from startT to the end.}
\item{list_paraEst}{Parameter estimates at each time grid from startT to the end.}
}
\description{
\code{modelFit} outputs the FPCA (functional principal component analysis) decomposition and the parameter estimates
of the functional generalized linear model at each time grid.
}
\examples{
library(reinforcedPred)

# take the example training data (univariate Z) from the reinforcedPred package
# see documentation for details about the data set train_data_uniZ
Y <- as.numeric(train_data_uniZ$Y)
tildeX.missing <- as.matrix(train_data_uniZ[,2:62])
Z <- as.numeric(train_data_uniZ$Z)

# analysis starts
startT <- 55
link <- "probit"
weight <- rep(1, length(Y))

result <- modelFit(Y, tildeX.missing, Z, startT, link, pve = 0.99, nbasis = 10, weight)

# obtained parameter estimates and FPCA decompositions
list_paraEst <- result$list_paraEst
list_fpcaFit <- result$list_fpcaFit

}
