% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rcode.r
\name{rs.surv}
\alias{rs.surv}
\title{Compute a Relative Survival Curve}
\usage{
rs.surv(
  formula = formula(data),
  data = parent.frame(),
  ratetable = relsurv::slopop,
  na.action,
  fin.date,
  method = "pohar-perme",
  conf.type = "log",
  conf.int = 0.95,
  type = "kaplan-meier",
  add.times,
  precision = 1,
  rmap
)
}
\arguments{
\item{formula}{a formula object, with the response as a \code{Surv} object
on the left of a \code{~} operator, and, if desired, terms separated by the
\code{+} operator on the right. If no strata are used, \code{~1} should be
specified.

NOTE: The follow-up time must be in days.}

\item{data}{a data.frame in which to interpret the variables named in the
\code{formula}.}

\item{ratetable}{a table of event rates, organized as a \code{ratetable}
object, such as \code{slopop}.}

\item{na.action}{a missing-data filter function, applied to the model.frame,
after any subset argument has been used.  Default is
\code{options()$na.action}.}

\item{fin.date}{the date of the study ending, used for calculating the
potential follow-up times in the Hakulinen method. If missing, it is
calculated as \code{max(year+time)}.}

\item{method}{the method for calculating the relative survival. The options
are \code{pohar-perme}(default), \code{ederer1}, \code{ederer2} and
\code{hakulinen}.}

\item{conf.type}{one of \code{plain}, \code{log} (the default), or
\code{log-log}. The first option causes the standard intervals curve +- k
*se(curve), where k is determined from conf.int. The log option calculates
intervals based on the cumulative hazard or log(survival). The last option
bases intervals on the log hazard or log(-log(survival)).}

\item{conf.int}{the level for a two-sided confidence interval on the
survival curve(s). Default is 0.95.}

\item{type}{defines how survival estimates are to be calculated given the
hazards.  The default (\code{kaplan-meier}) calculates the product integral,
whereas the option \code{fleming-harrington} exponentiates the negative
cumulative hazard. Analogous to the usage in \code{survfit}.}

\item{add.times}{specific times at which the curve should be evaluated.}

\item{precision}{Precision for numerical integration. Default is 1, which
means that daily intervals are taken, the value may be decreased to get a
higher precision or increased to achieve a faster calculation. The
calculation intervals always include at least all times of event and
censoring as border points.}

\item{rmap}{an optional list to be used if the variables are not organized
and named in the same way as in the \code{ratetable} object. See details
below.}
}
\value{
a \code{survfit} object; see the help on \code{survfit.object} for
details.  The \code{survfit} methods are used for \code{print},
\code{summary}, \code{plot}, \code{lines}, and \code{points}.
}
\description{
Computes an estimate of the relative survival curve using the Ederer I,
Ederer II method, Pohar-Perme method or the Hakulinen method
}
\details{
NOTE: The follow-up time must be specified in days. The \code{ratetable}
being used may have different variable names and formats than the user's
data set, this is dealt with by the \code{rmap} argument. For example, if
age is in years in the data set but in days in the \code{ratetable} object,
age=age*365.241 should be used. The calendar year can be in any date format
(date, Date and POSIXt are allowed), the date formats in the
\code{ratetable} and in the data may differ.

The potential censoring times needed for the calculation of the expected
survival by the Hakulinen method are calculated automatically. The times of
censoring are left as they are, the times of events are replaced with
\code{fin.date - year}.

The calculation of the Pohar-Perme estimate is more time consuming since
more data are needed from the population tables.  The old version of the
function, now named \code{rs.survo} can be used as a faster version for the
Hakulinen and Ederer II estimate.

Numerical integration is required for Pohar-Perme estimate. The integration
precision is set with argument \code{precision}, which defaults to daily
intervals, a default that should give enough precision for any practical
purpose.

Note that even though the estimate is always calculated using numerical
integration, only the values at event and censoring times are reported.
Hence, the function \code{plot} draws a step function in between and the
function \code{summary} reports the value at the last event or censoring
time before the specified time. If the output of the estimated values at
other points is required, this should be specified with argument
\code{add.times}.
}
\examples{

data(slopop)
data(rdata)
#calculate the relative survival curve
#note that the variable year must be given in a date format and that 
#age must be multiplied by 365.241 in order to be expressed in days.
rs.surv(Surv(time,cens)~sex,rmap=list(age=age*365.241), ratetable=slopop,data=rdata)

}
\references{
Package: Pohar Perme, M., Pavlic, K. (2018) "Nonparametric
Relative Survival Analysis with the R Package relsurv". Journal of
Statistical Software. 87(8), 1-27, doi: "10.18637/jss.v087.i08" Theory:
Pohar Perme, M., Esteve, J., Rachet, B. (2016) "Analysing Population-Based
Cancer Survival - Settling the Controversies." BMC Cancer, 16 (933), 1-8.
doi:10.1186/s12885-016-2967-9. Theory: Pohar Perme, M., Stare, J., Esteve,
J. (2012) "On Estimation in Relative Survival", Biometrics, 68(1), 113-120.
doi:10.1111/j.1541-0420.2011.01640.x.
}
\seealso{
\code{survfit}, \code{survexp}
}
\keyword{survival}
