% Generated by roxygen2 (4.0.1): do not edit by hand
\name{denoise}
\alias{denoise}
\title{Noise filtering through principal components}
\usage{
denoise(x, k = NULL, expl.var = NULL, weighted = TRUE, ...)
}
\arguments{
\item{x}{RasterStack to be filtered}

\item{k}{number of components to be kept for reconstruction
(ignored if \code{expl.var} is supplied)}

\item{expl.var}{minimum amount of variance to be kept after reconstruction
(should be set to NULL or omitted if \code{k} is supplied)}

\item{weighted}{logical. If \code{TRUE} the covariance matrix will be
geographically weighted using the cosine of latitude during decomposition
(only important for lat/lon data)}

\item{...}{additional arguments passed to \code{\link{princomp}}}
}
\value{
a denoised RasterStack
}
\description{
Filter noise from a RasterStack by decomposing into principal components
and subsequent reconstruction using only a subset of components
}
\examples{
data("vdendool")
vdd_dns <- denoise(vdendool, expl.var = 0.8)

opar <- par(mfrow = c(1,2))
plot(vdendool[[1]], main = "original")
plot(vdd_dns[[1]], main = "denoised")
par(opar)
}
\seealso{
\code{\link{anomalize}}, \code{\link{deseason}}
}

