% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longtermMeans.R
\name{longtermMeans}
\alias{longtermMeans}
\title{Calculate long-term means from a 'RasterStack'}
\usage{
longtermMeans(x, cycle.window = 12L)
}
\arguments{
\item{x}{A 'RasterStack' (or 'RasterBrick') object.}

\item{cycle.window}{'integer'. See \code{\link{deseason}}.}
}
\value{
If \code{cycle.window} equals \code{nlayers(x)} (which obviously doesn't make 
much sense), a 'RasterLayer' object; else a 'RasterStack' object.
}
\description{
Calculate long-term means from an input 'RasterStack' (or 'RasterBrick') 
object. Ideally, the number of input layers should be divisable by the 
supplied \code{cycle.window}. For instance, if \code{x} consists of monthly 
layers, \code{cycle.window} should be a multiple of 12.
}
\examples{
data("australiaGPCP")

longtermMeans(australiaGPCP)

}
\author{
Florian Detsch
}
\seealso{
\code{\link{deseason}}.
}

