% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank.R
\name{rank}
\alias{rank}
\title{Refining evaluation methodology on stage system.}
\usage{
rank(os, ostime, groupvar, scheme, order, covariate, weight, data)
}
\arguments{
\item{os}{Survival indicator, 1 for death, 0 for censoring.}

\item{ostime}{Duration time of survival.}

\item{groupvar}{Basic group variable having the most number of stages.}

\item{scheme}{Different grouping scheme, which has less stages than the basic group variable.}

\item{order}{The other of stages in each grouping, from}

\item{covariate}{Covariate variables taking into consideration.}

\item{weight}{Weight on five measurements of grouping scheme.}

\item{data}{Data set.}
}
\value{
Ranking of five measurements, which are Hazard consistency, Hazard discrimination, Explained variation, Likelihood difference and Balance. By standardized each measurement score, we provides overall ranking of schemes.
}
\description{
\code{rank} returns five measurements for the grouping scheme and its overall rank.
}
\examples{
 
data(Rdata)
Scheme=c('Scheme.1','Scheme.2','Scheme.3')
Covar=c('Age','Treatment')
weight=c(1,1,0.5,0.5,1)
Order=list(c('I','II','III'),c('I','II','III','IV'),c('I','II','III','IV'))
rank(os='OS',ostime='survmonth',groupvar='Basic_group', scheme=Scheme, order=Order,
     covariate=Covar,weight=weight,data=Rdata)
}
\references{
Xu, W., et al. 'Refining evaluation methodology on TNM stage system: assessment on HPV-related oropharyngeal cancer.' Austin Biom Biostat 2 (2015): 1014.
}
