% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install Packages}
\usage{
install(
  packages = NULL,
  ...,
  library = NULL,
  type = NULL,
  rebuild = FALSE,
  prompt = interactive(),
  project = NULL
)
}
\arguments{
\item{packages}{A character vector of \R packages to install. Required
package dependencies (\code{Depends}, \code{Imports}, \code{LinkingTo}) will be installed
as required.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{type}{The type of package to install ("source" or "binary"). Defaults
to the value of \code{getOption("pkgType")}.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Install one or more \R packages from a variety of remote sources.
}
\details{
\code{install()} uses the same machinery as \code{\link[=restore]{restore()}} when installing packages.
In particular, this means that the local cache of package installations is
used when possible. This helps to avoid re-downloading packages that have
already been downloaded before, and re-compiling packages from source when
a binary copy of that package is already available.

Note that this interface is subject to change -- the goal is to hook into
separate package installation backends in the future.
}
\section{Bioconductor}{


Packages from Bioconductor can be installed by using the \verb{bioc::} prefix.
For example,\preformatted{renv::install("bioc::Biobase")
}

will install the latest-available version of \code{Biobase} from Bioconductor.

\code{renv} depends on \code{BiocManager} (or, for older versions of \R, \code{BiocInstaller})
for the installation of packages from Bioconductor. If these packages are
not available, \code{renv} will attempt to automatically install them before
fulfilling the installation request.
}

\section{Remotes Syntax}{


\code{renv} supports a subset of the \code{remotes} syntax used for package installation,
as described in \url{https://remotes.r-lib.org/articles/dependencies.html}. See
the examples below for more details.
}

\section{Package Configuration}{


Many \R packages have a \code{configure} script that needs to be run to prepare
the package for installation. Arguments and environment variables can be
passed through to those scripts in a manner similar to \link{install.packages}.
In particular, the \R options \code{configure.args} and \code{configure.vars} can be
used to map package names to their appropriate configuration. For example:\preformatted{# installation of RNetCDF may require us to set include paths for netcdf
configure.args = c(RNetCDF = "--with-netcdf-include=/usr/include/udunits2"))
options(configure.args = configure.args)
renv::install("RNetCDF")
}

Similarly, additional flags that should be passed to \verb{R CMD INSTALL} can
be set via the \code{install.opts} \R option:\preformatted{# installation of R packages using the Windows Subsystem for Linux
# may require the `--no-lock` flag to be set during install
options(install.opts = "--no-lock")
renv::install("xml2")
}
}

\examples{
\dontrun{

# install the latest version of 'digest'
renv::install("digest")

# install an old version of 'digest' (using archives)
renv::install("digest@0.6.18")

# install 'digest' from GitHub (latest dev. version)
renv::install("eddelbuettel/digest")

# install a package from GitHub, using specific commit
renv::install("eddelbuettel/digest@df55b00bff33e945246eff2586717452e635032f")

# install a package from Bioconductor
# (note: requires the BiocManager package)
renv::install("bioc::Biobase")

# install a package from local sources
renv::install("~/path/to/package")

}
}
