% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_table.R
\name{report_table}
\alias{report_table}
\title{Report a descriptive table}
\usage{
report_table(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link{report_table}}.
}
\description{
Creates tables to describe different objects (see list of supported objects
in \code{\link{report}}).
}
\examples{
\donttest{
library(report)

# Miscellaneous
r <- report_table(sessionInfo())
r
summary(r)

# Data
report_table(iris$Sepal.Length)
report_table(as.character(round(iris$Sepal.Length, 1)))
report_table(iris$Species)
report_table(iris)

# h-tests
report_table(t.test(mpg ~ am, data = mtcars))
report_table(cor.test(iris$Sepal.Length, iris$Sepal.Width))

# ANOVAs
report_table(aov(Sepal.Length ~ Species, data = iris))

# GLMs
report_table(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_table(glm(vs ~ disp, data = mtcars, family = "binomial"))

# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  report_table(model)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 600)
  report_table(model, effectsize_method = "basic")
}

# Structural Equation Models (SEM)
if (require("lavaan")) {
  structure <- " ind60 =~ x1 + x2 + x3
                 dem60 =~ y1 + y2 + y3
                 dem60 ~ ind60 "
  model <- lavaan::sem(structure, data = PoliticalDemocracy)
  report_table(model)
}
}
}
