% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_info.R
\name{report_info}
\alias{report_info}
\title{Report additional information}
\usage{
report_info(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[=report_info]{report_info()}}.
}
\description{
Reports additional information relevant to the report (see list of supported
objects in \code{\link[=report]{report()}}).
}
\examples{
library(report)

# h-tests
report_info(t.test(iris$Sepal.Width, iris$Sepal.Length))

# ANOVAs
report_info(aov(Sepal.Length ~ Species, data = iris))
\donttest{
# GLMs
report_info(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_info(lm(Sepal.Length ~ Petal.Length * Species, data = iris), include_effectsize = TRUE)
report_info(glm(vs ~ disp, data = mtcars, family = "binomial"))

# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  report_info(model)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 300)
  report_info(model)
}
}
}
