% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lblCode.R
\name{extract_labels}
\alias{extract_labels}
\title{Extract variable labels from labelled data frame}
\usage{
extract_labels(data, sep = "_")
}
\arguments{
\item{data}{the data frame to extract labels from}

\item{sep}{character used to separate multiple labels, defaults to "_"}
}
\description{
Extract variable labels from data and return a data frame with labels
}
\details{
All variable names will be returned, even those with no labels.
If the label attribute has length greater than one the values will be
concatenated and returned as a single string separated by sep
}
\examples{
# Set a few variable labels for ctDNA
ctDNA <- ctDNA |> set_var_labels(
   ctdna_status="detectable ctDNA",
  cohort="A cohort label")
# Extract labels
extract_labels(ctDNA)
}
