% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ggkmcif_paste}
\alias{ggkmcif_paste}
\title{Plot KM and CIF curves with ggplot}
\usage{
ggkmcif_paste(list_gg)
}
\arguments{
\item{list_gg}{list containing the results of ggkmcif}
}
\value{
a gtable with three elements, the survival curve, a spacer and the
number at risk table
}
\description{
This function puts together a survival curve, and a number at risk table
}
\examples{
data("pembrolizumab")
plot <- ggkmcif(response=c('pfs_time','pfs_status'),
data=pembrolizumab,returns = TRUE)

# Highlighting a section of the curve
plot[[1]] <- plot[[1]] +
ggplot2::geom_rect(xmin=4,xmax=8,ymin=0.15,ymax=0.4,alpha=0.01,fill='yellow')

# Putting the curve back together
ggkmcif_paste(plot)
}
