% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_survtime}
\alias{rm_survtime}
\title{Display survival rates and events for specified times}
\usage{
rm_survtime(
  data,
  time,
  status,
  covs = NULL,
  strata = NULL,
  type = "KM",
  survtimes,
  survtimeunit,
  strata.prefix = NULL,
  survtimesLbls = NULL,
  showCols = c("At Risk", "Events", "Censored"),
  CIwidth = 0.95,
  conf.type = "log",
  na.action = "na.omit",
  showCounts = TRUE,
  digits = getOption("reportRmd.digits", 2),
  caption = NULL,
  tableOnly = FALSE,
  fontsize
)
}
\arguments{
\item{data}{data frame containing survival data}

\item{time}{string indicating survival time variable}

\item{status}{string indicating event status variable}

\item{covs}{character vector with the names of variables to adjust for in
coxph fit}

\item{strata}{string indicating the variable to group observations by. If
this is left as NULL (the default) then event counts and survival rates are
provided for the entire cohort.}

\item{type}{survival function, if no covs are specified defaults to
Kaplan-Meier, otherwise the Cox PH model is fit. Use type='PH' to fit a Cox
PH model with no covariates.}

\item{survtimes}{numeric vector specifying when survival probabilities should
be calculated.}

\item{survtimeunit}{unit of time to suffix to the time column label if
survival probabilities are requested, should be plural}

\item{strata.prefix}{character value describing the grouping variable}

\item{survtimesLbls}{if supplied, a vector the same length as survtimes with
descriptions (useful for displaying years with data provided in months)}

\item{showCols}{character vector specifying which of the optional columns to
display, defaults to c('At Risk','Events','Censored')}

\item{CIwidth}{width of the survival probabilities, default is 95\%}

\item{conf.type}{type of confidence interval see \code{\link{survfit}} for
details. Default is 'log'.}

\item{na.action}{default is to omit missing values, but can be set to throw
and error using na.action='na.fail'}

\item{showCounts}{boolean indicating if the at risk, events and censored
columns should be output, default is TRUE}

\item{digits}{the number of digits in the survival rate, default is 2.}

\item{caption}{table caption for markdown output}

\item{tableOnly}{should a dataframe or a formatted object be returned}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}
}
\value{
A character vector of the survival table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
This is a wrapper for the survfit function to output a tidy display for
reporting. Either Kaplan Meier or Cox Proportional Hazards models may be used
to estimate the survival probabilities.
}
\details{
If covariates are supplied then a Cox proportional hazards model is fit for
the entire cohort and each strata. Otherwise the default is for Kaplan-Meier
estimates. Setting type = 'PH' will force a proportional hazards model.
}
\examples{
# Kaplan-Mieir survival probabilities with time displayed in years
data("pembrolizumab")
rm_survtime(data=pembrolizumab,time='os_time',status='os_status',
strata="cohort",type='KM',survtimes=seq(12,72,12),
survtimesLbls=seq(1,6,1),
survtimeunit='years')

# Cox Proportional Hazards survivial probabilities
rm_survtime(data=pembrolizumab,time='os_time',status='os_status',
strata="cohort",type='PH',survtimes=seq(12,72,12),survtimeunit='months')

# Cox Proportional Hazards survivial probabilities controlling for age
rm_survtime(data=pembrolizumab,time='os_time',status='os_status',
covs='age',strata="cohort",survtimes=seq(12,72,12),survtimeunit='months')

}
\seealso{
\code{\link{survfit}}
}
