% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC data illustrate correlations
between results from individual participants in a family of three cross-over experiments
conducted by Torchiano et al:
[1] M. Torchiano, G. Scanniello, F. Ricca, G. Reggio, and M. Leotta,
"Do UML object diagrams affect design comprehensibility? Results
from a family of four controlled experiments." Journal of Visual Languages
and  Computing, vol. 41, pp. 10–21, 2017.
Although the paper reports four experiment, we only have data from three of those experiments.
The experiments assess whether the comprehensibility of UML specifications improve when the
software documents include UML object diagrams as well as the standard UML class diagrams.
If you use this data set please cite:
[1] M. Torchiano, G. Scanniello, F. Ricca, G. Reggio, and M. Leotta,
"Do UML object diagrams affect design comprehensibility? Results
from a family of four controlled experiments." Journal of Visual Languages
and  Computing, vol. 41, pp. 10–21, 2017.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
A data frame with 214 rows and 8 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each of the three experiments
in the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A , B , C, D}
\item{System}{<fct>|Software systems used in the experiment: File System manager (FS) for
folders, files, links. Roads system (R) handles maps made up of cities connected by means of
roads. Train (T) a system to manage timetables, trains, and paths. Catalogue system (C).
It collects category of items (e.g., cars) and items (e.g., car models) based on a set of
features (e.g., number of  doors). In PoliTo2, only FS and T were administered to the
participants, while in UniBas1 and UniGe1 all the four experimental objects were used. }
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment: Object Diagram (OD) vs No Object Diagram (NoOD)}
\item{Comprehension}{<dbl>|Dependent variable: The comprehension level the software engineers.
For PoliTo2 Comprehension was based on answering a set of 4 questions, for UniBas and UniGe
comprehension was measured using the F metric. }
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For 2 group crossover,
the category is set to CO1 only}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC data illustrate correlations
between results from individual participants in a family of three cross-over experiments
conducted by Torchiano et al:
[1] M. Torchiano, G. Scanniello, F. Ricca, G. Reggio, and M. Leotta,
"Do UML object diagrams affect design comprehensibility? Results
from a family of four controlled experiments." Journal of Visual Languages
and  Computing, vol. 41, pp. 10–21, 2017.
Although the paper reports four experiment, we only have data from three of those experiments.
The experiments assess whether the comprehensibility of UML specifications improve when the
software documents include UML object diagrams as well as the standard UML class diagrams.
If you use this data set please cite:
[1] M. Torchiano, G. Scanniello, F. Ricca, G. Reggio, and M. Leotta,
"Do UML object diagrams affect design comprehensibility? Results
from a family of four controlled experiments." Journal of Visual Languages
and  Computing, vol. 41, pp. 10–21, 2017.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Torchiano17JVLC

}
\keyword{datasets}
