% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculateKendalltaupb}
\alias{calculateKendalltaupb}
\title{@title calculateKendalltaupb
 @description  Computes point bi-serial version of  Kendall's tau plus a 1-alpha confidence interval using the method recommended by Long and Cliff (1997).  The algorithm is based on Wilcox's code but was extended to return the consistent variance and the confidence intervals based on the t-distribution. Also added a Diagnostic parameter to output internal calculations.}
\usage{
calculateKendalltaupb(x, y = NULL, alpha = 0.05, alternative = "two.sided")
}
\arguments{
\item{x}{either a matrix with two columns containing two correlated variables or a vector of variables}

\item{y}{if y=NULL, assume x is a matrix with two columns, otherwise y is a vector of variables with x[i] and y[i] being from the same experimental unit}

\item{alpha}{the Type 1 error level used for statistical tests (default 0.05)}

\item{alternative}{The type of statistical test. Valid values are one of
c('two.sided', 'greater', 'less')}
}
\value{
list containing the estimate of Kendall's tau, the consistent variance of tau and its confidence intervals based on the t-test (recommended by Long and Cliff)
}
\description{
@title calculateKendalltaupb
 @description  Computes point bi-serial version of  Kendall's tau plus a 1-alpha confidence interval using the method recommended by Long and Cliff (1997).  The algorithm is based on Wilcox's code but was extended to return the consistent variance and the confidence intervals based on the t-distribution. Also added a Diagnostic parameter to output internal calculations.
}
\examples{
set.seed(123)
a <- c(1.2, 3, 1.8, 2, 2, 0.5, 0.5, 1, 3, 1)
b <- c(1, 1, 1, 1, 1, 0, 0, 0, 0, 0)
calculateKendalltaupb(a,b,alpha=.05)
#$cor
#[1] 0.3555556
#$cit
#[1] -0.1240567  0.5555556
#$n
#[1] 10
#$df
#[1] 7
#$consistentvar
#[1] 0.04113925
#$sig
#[1] FALSE
set.seed(234)
a2=c(rnorm(10,0,1),rnorm(10,0.5,1))
b2=c(rep(0,10),rep(1,10))
calculateKendalltaupb(a2,b2,alpha=.05,alternative='greater')
#$cor
#[1] 0.2842105
#$cit
#[1] 0.06517342 0.52631579
#$n
#[1] 20
#$df
#[1] 17
#consistentvar
#1] 0.01585379
#$sig
#[1] TRUE
calculateKendalltaupb(a2,b2,alpha=.05,alternative='less')
#$cor
#[1] 0.2842105
#$cit
#[1] -0.5263158  0.5032476
#$n
#[1] 20
#$df
#[1] 17
#$consistentvar
#[1] 0.01585379
#$sig
#[1] FALSE
}
\author{
Rand Wilcox, Barbara Kitchenham and Lech Madeyski
}
