% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{opls_get_basics}
\alias{opls_get_basics}
\title{fast orthogonal scores algorithn of partial leat squares (opls)}
\usage{
opls_get_basics(X, Y, ncomp, scale, 
                maxiter, tol)
}
\arguments{
\item{X}{a matrix of predictor variables.}

\item{Y}{a matrix of either a single or multiple response variables.}

\item{ncomp}{the number of pls components.}

\item{scale}{logical indicating whether \code{X} must be scaled.}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{coefficients}}{ the matrix of regression coefficients.}
\item{\code{bo}}{ a matrix of one row containing the intercepts for each component.}
\item{\code{Y_loadings}}{ the matrix of Y loadings.}
\item{\code{projection_mat}}{ the projection matrix.}
\item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}. 
}
}
\description{
Computes orthogonal socres partial least squares (opls) 
regressions with the NIPALS algorithm. It allows multiple response variables. 
In contrast to code{opls} function, this one does not compute unnecessary 
data for (local) regression.
For internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
