% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{opls_get_all}
\alias{opls_get_all}
\title{orthogonal scores algorithn of partial leat squares (opls_get_all)}
\usage{
opls_get_all(X, 
             Y, 
             ncomp, 
             scale, 
             maxiter, 
             tol, 
             algorithm = "pls", 
             xls_min_w = 3, 
             xls_max_w = 15)
}
\arguments{
\item{X}{a matrix of predictor variables.}

\item{Y}{a matrix of either a single or multiple response variables.}

\item{ncomp}{the number of pls components.}

\item{scale}{logical indicating whether \code{X} must be scaled.}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}

\item{algorithm}{(for weights computation) a character string indicating
what method to use. Options are:
\code{'pls'} for pls (using covariance between X and Y),
\code{'mpls'} for modified pls (using correlation between X and Y) or
\code{'xls'} for extended pls (as implemented in BUCHI NIRWise PLUS software).}

\item{xls_min_w}{(for weights computation) an integer indicating the minimum window size for the "xls"
method. Only used if \code{algorithm = 'xls'}. Default is 3 (as in BUCHI NIRWise PLUS software).}

\item{xls_max_w}{(for weights computation) an integer indicating the maximum window size for the "xls"
method. Only used if \code{algorithm = 'xls'}. Default is 15 (as in BUCHI NIRWise PLUS software).}
}
\value{
a list containing the following elements:
\itemize{
\item{\code{ncomp}}{ the number of components used.}
\item{\code{coefficients}}{ the matrix of regression coefficients.}
\item{\code{bo}}{ a matrix of one row containing the intercepts for each component.}
\item{\code{scores}}{ the matrix of scores.}
\item{\code{X_loadings}}{ the matrix of X loadings.}
\item{\code{Y_loadings}}{ the matrix of Y loadings.}
\item{\code{vip}}{ the projection matrix.}
\item{\code{selectivity_ratio}}{ the matrix of selectivity ratio (see Rajalahti, Tarja, et al. 2009).}
\item{\code{Y}}{ the \code{Y} input.}
\item{\code{variance}}{ a \code{list} conating two objects: \code{x_var} and \code{y_var}.
These objects contain information on the explained variance for the \code{X} and \code{Y} matrices respectively.}
\item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}.
\item{\code{weights}}{ the matrix of wheights.}}
}
\description{
Computes orthogonal socres partial least squares (opls_get_all)
regressions with the NIPALS algorithm. It retrives a comprehensive set of
pls outputs (e.g. vip and sensivity radius). It allows multiple response
variables. NOTE: For internal use only!
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}
