% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reservoir.R
\name{link}
\alias{link}
\title{Link two :py:class:\code{~.Node} instances to form a :py:class:\code{~.Model}
instance. \code{node1} output will be used as input for \code{node2} in the
created model. This is similar to a function composition operation:}
\usage{
link(node1, node2, name = NULL)
}
\arguments{
\item{node1}{(Node) or (list_of_Node)
Nodes or lists of nodes to link.}

\item{node2}{(Node) or (list_of_Node)
Nodes or lists of nodes to link.}

\item{name}{(str) optional
Name for the chaining Model.}
}
\value{
A reservoir model linking node1 and node2.
}
\description{
Link two :py:class:\code{~.Node} instances to form a :py:class:\code{~.Model}
instance. \code{node1} output will be used as input for \code{node2} in the
created model. This is similar to a function composition operation:
}
\details{
Can update the state of the node several times
}
\examples{
if(reticulate::py_module_available("reservoirpy")){
reservoir <- reservoirnet::createNode(nodeType = "Reservoir",
                                      seed = 1,
                                      units = 100,
                                      lr = 0.7,
                                      sr = 1,
                                      input_scaling = 1)
readout <- reservoirnet::createNode(nodeType = "Ridge", ridge = 0.1)
model <- reservoirnet::link(reservoir, readout)
}

}
