% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gamma.R
\name{dist_gamma}
\alias{dist_gamma}
\title{Gamma distribution}
\usage{
dist_gamma(shape = NULL, rate = NULL)
}
\arguments{
\item{shape}{Scalar shape parameter, or \code{NULL} as a placeholder.}

\item{rate}{Scalar rate parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{GammaDistribution} object.
}
\description{
See \link[stats:GammaDist]{stats::GammaDist}.
}
\details{
Both parameters can be overridden with
\code{with_params = list(shape = ..., rate = ...)}.
}
\examples{
alpha <- 2
beta <- 2

d_gamma <- dist_gamma(shape = alpha, rate = beta)
x <- d_gamma$sample(100)
d_emp <- dist_empirical(x, positive = TRUE)

plot_distributions(
  empirical = d_emp,
  theoretical = d_gamma,
  estimated = d_gamma,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "gamma")$estimate
    )
  ),
  .x = seq(1e-3, max(x), length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
