% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residlife.R
\name{residlife}
\alias{residlife}
\title{Calculating Residual Life Values}
\usage{
residlife(values, distribution, parameters, p = 0.5, type = "mean")
}
\arguments{
\item{values}{Range of values over which residual life is calculated.Usually given as a vector.}

\item{distribution}{Name of the distribution. Needs to be one of 'weibull', 'gompertz',
'gamma', 'gengamma.orig', 'exponential', 'lnorm', or 'llogis', 'genf', or 'genf.orig'.}

\item{parameters}{Parameters of the survival function. Needs to be inputted
in order as a vector, with the name of the parameter included.}

\item{p}{Percentile at which to calculate residual life. Default is .5.}

\item{type}{Type of residual life outputted. Must be "mean", "median", "percentile",
or "all". Default is "mean".}
}
\value{
The residual life for a specified sequence of values.
}
\description{
Calculates residual life values over a range of values. Allows the user to specify the
distribution and the parameters.
}
\examples{
residlife(values = 0:60, distribution= 'weibull', parameters = c(shape = 1.2, scale = 3))
residlife(values = 15:35, distribution= 'gamma', parameters =  c(shape = 1.2, rate =  1.7),
p = .25, type ='all')

}
\references{
Jackson CH (2016). “flexsurv: a platform for parametric survival modeling in R.” Journal of
statistical software, 70.

Poynor V (2010). “Bayesian inference for mean residual life functions in survival analysis.”
Masters diss., University of California, Santa Cruz.

Prentice RL (1975). “Discrimination among some parametric models.” Biometrika, 62(3),
607–614.

Stacy EW (1962). “A generalization of the gamma distribution.” The Annals of mathematical
statistics, pp. 1187–1192
}
