% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_NH4.R
\encoding{UTF-8}
\name{predict_NH4}
\alias{predict_NH4}
\title{Predict NH4 concentration post-respiration}
\usage{
predict_NH4(o2_drop = 10, o2_unit = "percent_a.s.", o2_nh4_ratio,
  temp = 25, sal = 35, atm_pres = 1013.25)
}
\arguments{
\item{o2_drop}{a numeric value or vector describing the change in O2. Default is 10.}

\item{o2_unit}{a string describing the unit used to measure \code{o2_drop}. Default is "percent_a.s." Options are from \code{\link{conv_o2}}.}

\item{o2_nh4_ratio}{molar ratio of O2 consumed to NH4+ produced.}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
The predicted NH4+ produced in mg/l.
}
\description{
Predicts the [NH4+] of seawater after a defined amount of oxygen consumption.
}
\details{
Given a known amount of oxygen consumed and an estimated O:N ratio, the amount of NH4 produced can be estimated. Production or consumption of ammonium by "background" microbes or conversion of ammonium to nitrite and nitrate is ignored since bacteria in the respirometer are typically sought to be in low levels.

o2_unit = "percent_a.s.", o2_nh4_ratio, temp = 25, sal = 35, atm_pres = 1013.25
}
\examples{
predict_NH4(o2_drop = 25, o2_nh4_ratio = 10)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{conv_o2}}, \code{\link{conv_NH4}}
}

