% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_E.R
\encoding{UTF-8}
\name{calc_E}
\alias{calc_E}
\title{Calculate E temperature coefficient}
\usage{
calc_E(x, temp)
}
\arguments{
\item{x}{a numeric vector of rate values (e.g. MO2) or any other values (e.g. Pcrit).}

\item{temp}{a numeric vector of temperature values (in Celsius).}
}
\description{
An E value is a relatively recent metric to parameterize the temperature-sensitivity of a biological rate (MO2). It is similar conceptually (but not numerically) to Q10.
}
\details{
E is the slope of the relationship between \code{-ln(x)} and \code{1/(kB T)}, where \code{kB} is the Boltzmann constant expressed in eV/K.
}
\examples{
calc_E(x = c(1, 2, 3), temp = c(10, 20, 30))

}
\references{
Deutsch, Curtis et al. 2015. “Climate Change Tightens a Metabolic Constraint on Marine Habitats.” Science 348(6239): 1132–35.
}
\seealso{
\code{\link{Q10}}, \code{\link{adj_by_temp}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
