% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_distributions.R
\name{resp_distributions}
\alias{resp_distributions}
\title{Compute response distribution indicators}
\usage{
resp_distributions(x, min_valid_responses = 1)
}
\arguments{
\item{x}{A data frame containing survey responses in wide format. For more information
see section "Data requirements" below.}

\item{min_valid_responses}{numeric between 0 and 1. Defines the share of valid responses
a respondent must have to calculate response quality indicators. Default is 1.}
}
\value{
Returns a data frame with response quality indicators per respondent.
Dimensions:
\itemize{
\item Rows: Equal to number of rows in x.
\item Columns: Six, one for each response distribution indicator.
}
}
\description{
Compute response distribution indicators for responses to multi-item scales or matrix
questions.
}
\details{
The following response distribution indicators are calculated per respondent:
\itemize{
\item n_na: number of intra-individual missing answers
\item prop_na: proportion of intra-individual missing responses
\item ii_mean: intra-individual mean
\item ii_median: intra-individual median
\item ii_sd:  intra-individual standard deviation
\item mahal: mahalanobis distance per respondent.
}

Intra-individual response variability (ii_sd) has been
proposed to measure insufficient effort responding (Dunn et al., 2018) and to
distinguish between random and conscientious responding (Marjanovic et al, 2015).

Intra-individual location indicators can be used to asses the average location
of responses on a set of questions (ii_mean, ii_median).

Mahalanobis distance is a outlier detection indicator. It represents the distance
of a participants responses from the center of a multivariate normal distribution
defined by the data of all respondents.
}
\section{Data requirements}{

\code{resp_distributions()} assumes that data comes from multi-item scales or matrix questions,
which have the same number and labeling of response options for many questions.
The input data frame must be structured in the following way:
\itemize{
\item The data frame is in wide format, meaning each row represents one respondent, each
column represents one variable.
\item All responses have integer values.
\item Missing values are set to \code{NA}.
}
}

\section{Reverse coding of variables}{

The interpretation of the indicators depends on the whether response
data of negatively worded questions was reversed or not:
\itemize{
\item Do not reverse data of negatively worded questions if you want to assess
average response patterns (Dunn et al., 2018).
\item Reverse data of negatively worded questions if you want to assess whether
responses are distributed randomly or not with respect to an assumed
latent variable (Marjanovic et al., 2015).
}
}

\section{Mahalanobis distance could not be calculated}{

Under certain circumstances, the mahalanobis distance can not be calculated.
This may be if there is high collinearity (correlation between variables) or
if there are to many missing values.
Although this can happen in survey research data, this message can also
indicate that something in the data is "off" due to one of the reasons stated
above. A manual inspection for low-quality responses can be a next step.
}

\examples{
# A small test data set with ten respondents
# and responses to three survey questions
# with response scales from 1 to 5.
testdata <- data.frame(
  var_a = c(1,4,3,5,3,2,3,1,3,NA),
  var_b = c(2,5,2,3,4,1,NA,2,NA,NA),
  var_c = c(1,2,3,NA,3,4,4,5,NA,NA))

# Calculate response distribution indicators
resp_distributions(x = testdata) |>
    round(2)

# Include respondents with NA values by decreasing the
# necessary number of valid responses per respondent.

resp_distributions(
      x = testdata,
      min_valid_responses = 0.2) |>
   round(2)

}
\references{
Dunn, Alexandra M., Eric D. Heggestad, Linda R. Shanock, and Nels Theilgard. 2018.
“Intra-Individual Response Variability as an Indicator of Insufficient Effort Responding:
Comparison to Other Indicators and Relationships with Individual Differences.”
Journal of Business and Psychology 33(1):105–21. doi: 10.1007/s10869-016-9479-0.

Marjanovic, Zdravko, Ronald Holden, Ward Struthers, Robert Cribbie,
and Esther Greenglass. 2015. “The Inter-Item Standard Deviation (ISD):
An Index That Discriminates between Conscientious and Random Responders.”
Personality and Individual Differences 84:79–83.
doi: 10.1016/j.paid.2014.08.021.
}
\seealso{
\code{\link[=resp_styles]{resp_styles()}} for calculating response style indicators.
}
\author{
Matthias Roth, Matthias Bluemke & Clemens Lechner
}
