% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-tools.R
\name{gb_organism_get}
\alias{gb_organism_get}
\title{Get organism from GenBank}
\usage{
gb_organism_get(id)
}
\arguments{
\item{id}{character, sequence accession ID(s)}
}
\value{
named vector of definitions, if no results found NULL
}
\description{
Return the organism name
for an accession ID.
}
\examples{
library(restez)
restez_path_set(filepath = tempdir())
demo_db_create(n = 5)
restez_connect()
(org <- gb_organism_get(id = 'demo_1'))
(orgs <- gb_organism_get(id = c('demo_1', 'demo_2')))


# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
Other get: \code{\link{gb_definition_get}},
  \code{\link{gb_fasta_get}}, \code{\link{gb_record_get}},
  \code{\link{gb_sequence_get}},
  \code{\link{gb_version_get}}
}
\concept{get}
