/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.objective.AbstractObjManager;
import org.chocosolver.solver.variables.RealVar;

abstract class AbstractRealObjManager
extends AbstractObjManager<RealVar> {
    private static final long serialVersionUID = 8038511375883592639L;

    public AbstractRealObjManager(AbstractObjManager<RealVar> objman) {
        super(objman);
    }

    public AbstractRealObjManager(RealVar objective, ResolutionPolicy policy, Number precision) {
        super(objective, policy, precision);
        double prec = Math.abs(precision.doubleValue());
        this.bestProvedLB = objective.getLB() - prec;
        this.bestProvedUB = objective.getUB() + prec;
    }

    @Override
    public synchronized boolean updateBestLB(Number lb) {
        if (this.bestProvedLB.doubleValue() < lb.doubleValue()) {
            this.bestProvedLB = lb;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean updateBestUB(Number ub) {
        if (this.bestProvedUB.doubleValue() > ub.doubleValue()) {
            this.bestProvedUB = ub;
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBestSolution() {
        assert (((RealVar)this.objective).isInstantiated());
        return this.updateBestSolution(((RealVar)this.objective).getUB());
    }

    @Override
    public void setStrictDynamicCut() {
        this.cutComputer = n -> n.doubleValue() + this.precision.doubleValue();
    }

    private int getNbDecimals() {
        int dec = 0;
        double p = this.precision.doubleValue();
        while ((int)p <= 0 && dec <= 12) {
            ++dec;
            p *= 10.0;
        }
        return dec;
    }

    @Override
    public void resetBestBounds() {
        double prec = Math.abs(this.precision.doubleValue());
        this.bestProvedLB = ((RealVar)this.objective).getLB() - prec;
        this.bestProvedUB = ((RealVar)this.objective).getUB() + prec;
    }

    public String toString() {
        return String.format("%s %s = %." + this.getNbDecimals() + "f", new Object[]{this.policy, this.objective == null ? "?" : ((RealVar)this.objective).getName(), this.getBestSolutionValue().doubleValue()});
    }
}

